function [b]=WSharpening(a,W,t)
%  Sharpening of gray-scale image
% a Input image (must be gray scale)
% W Thrshold for sharpening (second coef.). It is similar to k of
% unsharpmask  algorithm
% t weighted cof for T1 and T2 thresholds. Default value 1 
% b final sharpened image

wname = 'haar';
[wc,s] = wavedec2(a,3,wname);

% Extract the level 1 coefficients.
a1 = appcoef2(wc,s,wname,1);         
[h1,v1,d1] = detcoef2('all',wc,s,1);           

% Extract the level 2 coefficients.
a2 = appcoef2(wc,s,wname,2);
[h2,v2,d2] = detcoef2('all',wc,s,2);           

% Extract the level 3 coefficients.
a3 = appcoef2(wc,s,wname,3);
[h3,v3,d3] = detcoef2('all',wc,s,3); 

rd1 = wrcoef2('d',wc,s,wname,1); 
rd2 = wrcoef2('d',wc,s,wname,2); 
rh1 = wrcoef2('h',wc,s,wname,1); 
rh2 = wrcoef2('h',wc,s,wname,2); 
rv1 = wrcoef2('v',wc,s,wname,1); 
rv2 = wrcoef2('v',wc,s,wname,2); 

sz3=size(a)/8;
for i=0:sz3(1)-1
    for j=0:sz3(2)-1
        T2d=abs(d2(2*i+1,2*j+1)+d2(2*i+2,2*j+1)+d2(2*i+1,2*j+2)+d2(2*i+2,2*j+2))/4;
        T2h=abs(h2(2*i+1,2*j+1)+h2(2*i+2,2*j+1)+h2(2*i+1,2*j+2)+h2(2*i+2,2*j+2))/4;
        T2v=abs(v2(2*i+1,2*j+1)+v2(2*i+2,2*j+1)+v2(2*i+1,2*j+2)+v2(2*i+2,2*j+2))/4;
        for m=0:1
            for n=0:1
             T1d=abs(d1(4*i+1+2*m,4*j+1+2*n)+d1(4*i+2+2*m,4*j+1+2*n)+d1(4*i+1+2*m,4*j+2+2*n)+d1(4*i+2+2*m,4*j+2+2*n))/4;
             T1h=abs(h1(4*i+1+2*m,4*j+1+2*n)+h1(4*i+2+2*m,4*j+1+2*n)+h1(4*i+1+2*m,4*j+2+2*n)+h1(4*i+2+2*m,4*j+2+2*n))/4;
             T1v=abs(v1(4*i+1+2*m,4*j+1+2*n)+v1(4*i+2+2*m,4*j+1+2*n)+v1(4*i+1+2*m,4*j+2+2*n)+v1(4*i+2+2*m,4*j+2+2*n))/4;
        
                for k=0:1
                    for l=0:1
                        if(abs(d3(i+1,j+1)+d2(2*i+1+m,2*j+1+n)+d1(4*i+1+2*m+k,4*j+1+2*n+l))<t*T1d)
                            d1(4*i+1+2*m+k,4*j+1+2*n+l)=0;
                        end
                        if(abs(h3(i+1,j+1)+h2(2*i+1+m,2*j+1+n)+h1(4*i+1+2*m+k,4*j+1+2*n+l))<t*T1h)
                            h1(4*i+1+2*m+k,4*j+1+2*n+l)=0;
                        end
                        if(abs(v3(i+1,j+1)+v2(2*i+1+m,2*j+1+n)+v1(4*i+1+2*m+k,4*j+1+2*n+l))<t*T1v)
                            v1(4*i+1+2*m+k,4*j+1+2*n+l)=0;
                        end
                    end
                end
                if(abs(d3(i+1,j+1)+d2(2*i+1+m,2*j+1+n))<t*T2d)
                    d2(2*i+1+m,2*j+1+n)=0;
                end
                if(abs(h3(i+1,j+1)+h2(2*i+1+m,2*j+1+n))<t*T2h)
                    h2(2*i+1+m,2*j+1+n)=0;
                end
                if(abs(v3(i+1,j+1)+v2(2*i+1+m,2*j+1+n))<t*T2v)
                    v2(2*i+1+m,2*j+1+n)=0;
                end
            end
        end 
    end
end

a3r=reshape(a3,1,s(1,1)*s(1,2));
h3r=reshape(h3,1,s(1,1)*s(1,2));
v3r=reshape(v3,1,s(1,1)*s(1,2));
d3r=reshape(d3,1,s(1,1)*s(1,2));

h2r=reshape(h2,1,s(3,1)*s(3,2));
v2r=reshape(v2,1,s(3,1)*s(3,2));
d2r=reshape(d2,1,s(3,1)*s(3,2));

h1r=reshape(h1,1,s(4,1)*s(4,2));
v1r=reshape(v1,1,s(4,1)*s(4,2));
d1r=reshape(d1,1,s(4,1)*s(4,2));

C=[a3r,h3r,v3r,d3r,h2r,v2r,d2r,h1r,v1r,d1r];
rd1 = wrcoef2('d',C,s,wname,1); 
rd2 = wrcoef2('d',C,s,wname,2); 
rh1 = wrcoef2('h',C,s,wname,1); 
rh2 = wrcoef2('h',C,s,wname,2); 
rv1 = wrcoef2('v',C,s,wname,1); 
rv2 = wrcoef2('v',C,s,wname,2); 

b=a+uint8(W*(rd1+rd2+rh1+rh2+rv1+rv2));

end




